capture log close
qui cd C:\Dropbox\WORK\Research\PLAG-UNIBE-ETH2011\paperSRM\resubmit\analysis

version 13.1
discard
clear all
set linesize 120
set type double
set more off


// compute relative effects (percentage increase in prevalence estimate)

est clear
qui estread log/main/detailed1
foreach v in q14 q16 q17 q18 q19 {
    est restore `v'
    nlcom (FRwheel: (_b[FRwheel]/_b[DQ]-1)*100) ///
          (FRnumb:  (_b[FRnumb]/_b[DQ]-1)*100) ///
          (UQbenf:  (_b[UQbenf]/_b[DQ]-1)*100) ///
          (CMquest: (_b[CMquest]/_b[DQ]-1)*100) ///
          (CMnumb:  (_b[CMnumb]/_b[DQ]-1)*100) ///
          , post
    est sto _`v'
}
esttab _*, mti nonumb b(a1) nostar ci modelw(14)


// Test differences in relative effects for CMQuest
clear all
use http://repec.sowi.unibe.ch/files/wp8/ASQ-ETHBE-2011.dta
// - exclude observartions who did not reach the sensitive questions intro page
// - exclude obervations that did not see the sensive questions because they 
//   did not yet have exampe and did not write a paper yet
// - exclude observations where assignment of expcond failed
// - generate language filter variable (well or very well german skills)
drop if expcond>=.
drop if (q17==.e & q19==.e) // one obs with valid expcond who was filtered for all items
qui recode expcond ///
    (1 = 1 "DQ") ///
    (4 = 2 "FRwheel") ///
    (2 = 3 "FRnumb") ///
    (5 = 4 "UQbenf") ///
    (6 = 5 "CMquest") ///
    (3 = 6 "CMnumb") ///
    , gen(expcond1)
drop expcond
rename expcond1 expcond
gen byte language = inlist(q4_2,4,5)
gen byte nopretest = (sample!=2)
keep if language

// Treatment variables
gen byte DQ      = expcond==1
gen byte FRwheel = expcond==2
gen byte FRnumb  = expcond==3
gen byte UQbenf  = expcond==4
gen byte CMquest  = expcond==5
gen byte CMnumb   = expcond==6

// reshape
keep id DQ FR* UQbenf CM* q14* q16* q17* q18* q19*
drop *_uq *_seed
local i 0
foreach v in q14 q16 q17 q18 q19 {
    local ++i
    rename `v' sq`i'
    rename `v'_pyes pyes`i'
    rename `v'_pno pno`i'
    rename `v'_pcm pcm`i'
}
reshape long sq pyes pno pcm, i(id) j(sqid)
fre sqid
forv i=1/5 {
    gen byte DQ`i' = DQ & sqid==`i'
    foreach v in FRwheel FRnumb UQbenf CMquest CMnumb {
        gen byte `v'`i' = `v' & sqid==`i'
    }
}
rrreg sq DQ? FRwheel? FRnumb? UQbenf? CMquest? CMnumb? ///
    , nocons vce(cluster id) pyes(pyes) pno(pno) pwarner(pcm)
nlcom (_1: (_b[CMquest1]/_b[DQ1]-1)*100) ///
      (_2: (_b[CMquest2]/_b[DQ2]-1)*100) ///
      (_3: (_b[CMquest3]/_b[DQ3]-1)*100) ///
      (_4: (_b[CMquest4]/_b[DQ4]-1)*100) ///
      (_5: (_b[CMquest5]/_b[DQ5]-1)*100) ///
    , post
test _1 = _2
test _1 = _3
test _2 = _3
test _1 = _4
test _2 = _4
test _1 = _5
test _2 = _5
test _3 = _4
test _3 = _5
test _4 = _5
test _1 = _2 = _3 = _4 = _5

exit
